<?php

$this->pageTitle = Yii::app()->name.' - Zarządzanie uczniami';

$this->breadcrumbs = array(
	'Zarządzanie uczniami',
);

?>
<h1>Zarządzanie uczniami</h1>

<?php

$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'uzytkownik-grid',
	'dataProvider'=>$model->search(array('condition'=>'"t"."status" NOT IN (2,3)')),
	'filter'=>$model,
	'htmlOptions' => array('class' => 'tDefault'),
	'itemsCssClass' => 'overflowClass',
	'columns'=>array(
		array(
			'name'=>'pesel',
			'type'=>'raw',
			'value'=>'"<a href=\"".Yii::app()->createUrl("administration/uzytkownik/update", array("id"=>$data->id))."\">".$data->pesel."</a>"',
		),
		'imie',
		'nazwisko',
		array(
			'header'=>'Szkoła',
			'name'=>'schoolName',
			'value'=>'!empty($data->klasa) && !empty($data->klasa->szkola) && !empty($data->klasa->szkola->nazwa) ? $data->klasa->szkola->nazwa : "brak"'
		),
		array(
			'header'=>'Klasa',
			'name'=>'className',
			'value'=>'!empty($data->klasa)?$data->klasa->nazwa:"brak"'
		),
		array(
			'header'=>'Firma',
			'name'=>'companyName',
			'value'=>'!empty($data->firma) ? $data->firma->nazwa:"brak"'
		),
		array(
			'class'=>'CButtonColumn',
			'template'=>'{view}<br/>{update}<br/>{delete}'
		),
	),
));

?>

<style type="text/css">
	body {
		xoverflow-x: scroll;
		xwidth: 100%
	}
	#uzytkownik-grid {
		xwidth: 94%;
		xoverflow-x: auto;
	}
</style>